#!/bin/sh

MASTER_PAGE_HA_RESULT_MSG=""
MASTER_PAGE_HA_RESULT_OK=0
MASTER_PAGE_HA_RESULT_ERROR=1

MASTER_PAGE_HA_RESULT_CODE=${MASTER_PAGE_HA_RESULT_ERROR}
MASTER_PAGE_HA_RESULT_ROLLING=0

master_page_ha() {
    
    local status=`/usr/bin/python /opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --current-status`
    #debug_print "${0}" "${LINENO}" 'in function "master_page_ha" account:$1'
    log "text ui: current status: $status, $PRODUCT_VERSION.$PRODUCT_BUILD_NUM"
    
    # prepare ha status data to be shown
    if [ "x$status" == "xprimary" ]; then
        local node_type="$MASTER_PAGE_HA_ACTIVE_NODE"
        local sub_title="$MASTER_PAGE_HA_STANDBY_DETAIL"
    elif [ "x$status" == "xsecondary" ]; then
        local node_type="$MASTER_PAGE_HA_STANDBY_NODE"
        local sub_title="$MASTER_PAGE_HA_ACTIVE_DETAIL"
    else
        tp_msg_ok \
            "${MASTER_PAGE_HA_TITLE}" \
            "\n$MASTER_PAGE_HA_SINGLE_DESC" \
            "${MASTER_PAGE_HA_LABEL_CANCEL}"
        MASTER_PAGE_HA_RESULT_CODE=${MASTER_PAGE_HA_RESULT_OK}
        MASTER_PAGE_HA_RESULT_ROLLING=-1
		return
    fi
    
    # sync peer ha info, including mgmt_ip and virtual ip
    `/usr/bin/python /opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --sync-info > /dev/null 2>&1`
     
    local sync_status=`/usr/bin/python /opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --query-drbd-state`
    log "sync_status $sync_status"
    if [ "x$sync_status" == "x-1" ]; then
        sync_status="$MASTER_PAGE_HA_DISCONNECTED"
    elif [ "x$sync_status" == "x100" ]; then
        sync_status="$MASTER_PAGE_HA_FULLY_SYNCED"
    else 
        #sync_status="$sync_status% $MASTER_PAGE_HA_SYNCED"
        sync_status="$MASTER_PAGE_HA_SYNCING $sync_status%..."
    fi
    local ip_v4=`get_config virtual_addr_ipv4`
    local ip_v6=`get_config virtual_addr_ipv6`
    local peer_hostname=`get_config peer_host_name`
    local peer_mgmt_ip=`get_config peer_mgmt_ip`
    
    # handle too long peer hostname
    local len=${#peer_hostname}
    log "peer_hostname [$peer_hostname], len [$len]"
    if [ $len -gt 37 ]; then
        log "peer_hostname [$peer_hostname] is too long, cut it"
        peer_hostname="${peer_hostname:0:37}..."
        log "peer_hostname [$peer_hostname]"
    fi
    
    if [ "x$status" == "xprimary" ]; then
        local text="\
\n\
Mode:                       $node_type\n\
IPv4 virtual address:       $ip_v4\n\
IPv6 virtual address:       $ip_v6\n\
\n\
$sub_title\n\
    Status:                 $sync_status\n\
    Host name:              $peer_hostname\n\
    Management IP address:  $peer_mgmt_ip"
     else     
        local text="\
\n\
Mode:                       $node_type\n\
Status:                     $sync_status\n\
\n\
$sub_title\n\
    Host name:              $peer_hostname\n\
    Management IP address:  $peer_mgmt_ip\n\
    IPv4 virtual address:   $ip_v4\n\
    IPv6 virtual address:   $ip_v6\n"
     fi
	
	# show ha status in Primary mode
	if [ "x$status" == "xprimary" ]; then
        tp_msg_ok \
	        "${MASTER_PAGE_HA_TITLE}" \
	        "${text}" \
	        "${MASTER_PAGE_HA_LABEL_CANCEL}"
	    MASTER_PAGE_HA_RESULT_CODE=${MASTER_PAGE_HA_RESULT_OK}
	    MASTER_PAGE_HA_RESULT_ROLLING=-1
		return
    fi
    
    # show ha status in standby mode
	tp_yesno \
	    "${MASTER_PAGE_HA_TITLE}" \
	    "${text}" \
	    "${MASTER_PAGE_HA_LABEL_OK}" \
	    "${MASTER_PAGE_HA_LABEL_CANCEL}"
	
	# no error cases
	MASTER_PAGE_HA_RESULT_CODE=${MASTER_PAGE_HA_RESULT_OK}    
    
	if [ "${TP_YESNO_RESULT_SELECT}" == "${TP_YESNO_RESULT_NO}" ]; then
		MASTER_PAGE_HA_RESULT_ROLLING=-1
		return
	fi
	
	# show ha status in standby mode
	tp_yesno \
	    "$MASTER_PAGE_HA_DETACH_TITLE" \
	    "${MASTER_PAGE_HA_DETACH_CONFORM_MSG}" \
	    "${MASTER_PAGE_HA_LABEL_OK}" \
	    "${MASTER_PAGE_HA_LABEL_CANCEL2}"
	    
    if [ "${TP_YESNO_RESULT_SELECT}" == "${TP_YESNO_RESULT_NO}" ]; then
		MASTER_PAGE_HA_RESULT_ROLLING=0
		return
    else
        MASTER_PAGE_HA_RESULT_ROLLING=-1        
	    
	    # perform detach
	    local res
	    res=`/usr/bin/python /opt/TrendMicro/DTAS/cluster/bin/ha_ctrl.py --detach-myself`
	    if [ "x$res" == "xsucc" ]; then
	        return
	    fi
	    if [ "x$res" == "xerror: -7" ]; then
	        text=$MASTER_PAGE_HA_SINGLE_DESC
	    elif [ "x$res" == "xerror: -15" ]; then
	        text="Data is still syncing"
	    else
            text="Fail to detach from cluster due to some errors"
	    fi
	    tp_msg_ok \
            "${MASTER_PAGE_HA_TITLE}" \
            "\n${text}" \
            "${MASTER_PAGE_HA_LABEL_CANCEL}"
		return
	fi
}
